#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=160810 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137914, 'Database Backup [database_backup_2024-11-22-00-02-02-v3-1-6.zip]', '2024-11-22 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138701, 'Database Backup [database_backup_2024-11-23-00-04-02-v3-1-6.zip]', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:22:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:22:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:22:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 19:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 19:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 19:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139377, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139378, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-23 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139484, 'Database Backup [database_backup_2024-11-24-00-04-02-v3-1-6.zip]', '2024-11-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 10:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 10:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 10:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 21:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 21:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 21:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-24 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-24 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-24 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140271, 'Database Backup [database_backup_2024-11-25-00-04-02-v3-1-6.zip]', '2024-11-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140629, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.112]', '2024-11-25 11:00:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140630, 'Invoice Status Updated [Invoice Number: INV-164/10/2024, From: Overdue To: Paid]', '2024-11-25 11:01:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140631, 'Payment Recorded [ID:121, Invoice Number: INV-164/10/2024, Total: $2,520.00]', '2024-11-25 11:01:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140632, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-11-25 11:01:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (140999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141065, 'Database Backup [database_backup_2024-11-26-00-04-01-v3-1-6.zip]', '2024-11-26 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (141695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-26 1