#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=351979 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329252, 'Invoice Status Updated [Invoice Number: INV-177/07/2025, From: Unpaid To: Overdue]', '2025-07-14 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329253, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329350, 'Database Backup [database_backup_2025-07-15-00-00-03-v3-3-1.zip]', '2025-07-15 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330008, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-15 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330009, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-15 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330010, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-15 21:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330011, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330108, 'Database Backup [database_backup_2025-07-16-00-03-03-v3-3-1.zip]', '2025-07-16 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 12:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 12:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 12:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 13:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 13:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 13:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330760, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330857, 'Database Backup [database_backup_2025-07-17-00-03-03-v3-3-1.zip]', '2025-07-17 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331506, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-17 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-17 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-17 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331603, 'Database Backup [database_backup_2025-07-18-00-02-03-v3-3-1.zip]', '2025-07-18 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (331999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332252, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332253, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332254, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332255, 'Invoice Status Updated [Invoice Number: INV-178/07/2025, From: Unpaid To: Overdue]', '2025-07-18 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332256, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-18 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332353, 'Database Backup [database_backup_2025-07-19-00-03-02-v3-3-1.zip]', '2025-07-19 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (332999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333002, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-19 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333099, 'Database Backup [database_backup_2025-07-20-00-00-03-v3-3-1.zip]', '2025-07-20 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-20 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (333163, 'Failed to connect to IMAP auto importi