#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=316564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290763, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290866, 'Database Backup [database_backup_2025-05-31-00-01-03-v3-1-6.zip]', '2025-05-31 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 02:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (290999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291554, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-31 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291555, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-05-31 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291556, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-05-31 21:01:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:01:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:01:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:01:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-31 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-31 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-31 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291659, 'Database Backup [database_backup_2025-06-01-00-00-07-v3-1-6.zip]', '2025-06-01 00:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (291999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292347, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-01 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 22:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 22:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 22:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-01 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-01 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-01 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292450, 'Database Backup [database_backup_2025-06-02-00-00-06-v3-1-6.zip]', '2025-06-02 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292916, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:3ce0:756b:3274:21e4]', '2025-06-02 14:06:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (292999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293148, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-06-02 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-02 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-02 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-02 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293251, 'Database Backup [database_backup_2025-06-03-00-02-03-v3-1-6.zip]', '2025-06-03 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293792, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:29d3:da92:e9dd:dfe6]', '2025-06-03 16:20:43', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293796, 'New Client Created [ID: 103, From Staff: 2]', '2025-06-03 16:27:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293803, 'Contact Created [ID: 112]', '2025-06-03 16:34:32', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293843, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Set New Password]', '2025-06-03 17:40:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293844, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Send Invoice to Customer]', '2025-06-03 17:41:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293956, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-03 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293957, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-06-03 21:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293958, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-06-03 21:05:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:05:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:05:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:05:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (293999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-03 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-03 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-03 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294058, 'Database Backup [database_backup_2025-06-04-00-00-03-v3-1-6.zip]', '2025-06-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-04 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (294644, '