#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=210323 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186310, 'Database Backup [database_backup_2025-01-22-00-05-02-v3-1-6.zip]', '2025-01-22 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187010, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-22 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187011, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-22 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187117, 'Database Backup [database_backup_2025-01-23-00-00-03-v3-1-6.zip]', '2025-01-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187823, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-23 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187929, 'Database Backup [database_backup_2025-01-24-00-00-03-v3-1-6.zip]', '2025-01-24 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (187999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188734, 'Database Backup [database_backup_2025-01-25-00-04-02-v3-1-6.zip]', '2025-01-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189437, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-25 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189438, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189541, 'Database Backup [database_backup_2025-01-26-00-00-02-v3-1-6.zip]', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `dat