#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=123554 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99224, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-04 10:02:01', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99687, 'Database Backup [database_backup_2024-10-05-00-00-04-v3-1-6.zip]', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100480, 'Database Backup [database_backup_2024-10-06-00-03-03-v3-1-6.zip]', '2024-10-06 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100526, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-06 01:25:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101175, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101275, 'Database Backup [database_backup_2024-10-07-00-02-02-v3-1-6.zip]', '2024-10-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-10-07 10:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101967, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.118]', '2024-10-07 21:16:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101974, 'Customer Info Updated [ID: 81]', '2024-10-07 21:31:50', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102002, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.118]', '2024-10-07 22:17:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102060, 'Database Backup [database_backup_2024-10-08-00-02-01-v3-1-6.zip]', '2024-10-08 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-08 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-08 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-08 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102847, 'Database Backup [database_backup_2024-10-09-00-00-04-v3-1-6.zip]', '2024-10-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102917, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.118]', '2024-10-09 02:11:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102921, 'Non Existing User Tried to Login [Email: bdallasferdinand@outlook.com, Is Staff Member: No, IP: 181.118.42.118]', '2024-10-09 02:14:29', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103054, 'Payment Recorded [ID:117, Invoice Number: INV-133/05/2024, Total: $5,295.00]', '2024-10-09 06:14:43', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103055, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-10-09 06:14:48', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103266, 'Invoice Status Updated [Invoice Number: INV-163/10/2024, From: Unpaid To: Paid]', '2024-10-09 12:43:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103267, 'Payment Recorded [ID:118, Invoice Number: INV-163/10/2024, Total: $999.00]', '2024-10-09 12:43:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103268, 'Email Sent To [Email: marc@apangsmarketing.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-10-09 12:43:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103478, 'Failed to connect to IMAP auto importing ti