#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=286068 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262636, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-25 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262637, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262743, 'Database Backup [database_backup_2025-04-26-00-03-03-v3-1-6.zip]', '2025-04-26 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263434, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-26 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263537, 'Database Backup [database_backup_2025-04-27-00-04-02-v3-1-6.zip]', '2025-04-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 08:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 08:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 08:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264318, 'Database Backup [database_backup_2025-04-28-00-01-04-v3-1-6.zip]', '2025-04-28 00:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (264999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265027, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-28 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265028, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-28 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265134, 'Database Backup [database_backup_2025-04-29-00-02-03-v3-1-6.zip]', '2025-04-29 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265828, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-29 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-29 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-29 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-29 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265928, 'Database Backup [database_backup_2025-04-30-00-00-09-v3-1-6.zip]', '2025-04-30 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (265999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-30 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-30 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (266492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-30 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `s