#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=270740 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246968, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Overdue Notice]', '2025-04-06 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246969, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Overdue Notice]', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (246999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-06 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-06 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-06 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247072, 'Database Backup [database_backup_2025-04-07-00-00-08-v3-1-6.zip]', '2025-04-07 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247784, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-07 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247785, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-07 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-07 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-07 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-07 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247891, 'Database Backup [database_backup_2025-04-08-00-02-02-v3-1-6.zip]', '2025-04-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (247999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248609, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-08 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-08 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248715, 'Database Backup [database_backup_2025-04-09-00-02-02-v3-1-6.zip]', '2025-04-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-09 05:32:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-09 05:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (248999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249426, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Overdue Notice]', '2025-04-09 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249427, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Overdue Notice]', '2025-04-09 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-09 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-09 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-09 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249533, 'Database Backup [database_backup_2025-04-10-00-00-06-v3-1-6.zip]', '2025-04-10 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249840, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-04-10 09:17:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249841, 'Invoice Status Updated [Invoice Number: INV-171/03/2025, From: Overdue To: Paid]', '2025-04-10 09:19:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249842, 'Payment Recorded [ID:124, Invoice Number: INV-171/03/2025, Total: 1,350.00$]', '2025-04-10 09:19:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249843, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-04-10 09:19:48', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249844, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-04-10 09:19:55', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (249999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250247, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-10 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250248, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250354, 'Database Backup [database_backup_2025-04-11-00-00-03-v3-1-6.zip]', '2025-04-11 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-11 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-11 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (250834, 'Fa