#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=246256 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (220999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221540, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221649, 'Database Backup [database_backup_2025-03-07-00-02-04-v3-1-6.zip]', '2025-03-07 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (221999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222487, 'Database Backup [database_backup_2025-03-08-00-04-03-v3-1-6.zip]', '2025-03-08 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (222999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223181, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-08 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223182, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-08 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-08 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-08 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-08 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223285, 'Database Backup [database_backup_2025-03-09-00-04-02-v3-1-6.zip]', '2025-03-09 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 12:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223991, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (223999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-09 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-09 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-09 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224097, 'Database Backup [database_backup_2025-03-10-00-00-06-v3-1-6.zip]', '2025-03-10 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-10 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-10 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-10 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224911, 'Database Backup [database_backup_2025-03-11-00-03-03-v3-1-6.zip]', '2025-03-11 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (224999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-11 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-11 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip