#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=94118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69524, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69624, 'Database Backup [database_backup_2024-08-29-00-00-03-v3-1-6.zip]', '2024-08-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70441, 'Database Backup [database_backup_2024-08-30-00-00-04-v3-1-6.zip]', '2024-08-30 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70994, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.154]', '2024-08-30 16:08:33', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70998, 'Payment Recorded [ID:112, Invoice Number: INV-125/04/2024, Total: $2,520.00]', '2024-08-30 16:19:49', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70999, 'Email Sent To [Email: keripatrick@me.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-30 16:19:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71000, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-08-30 16:19:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71004, 'Payment Recorded [ID:113, Invoice Number: INV-133/05/2024, Total: $5,295.00]', '2024-08-30 16:24:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71005, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-30 16:24:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71006, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-08-30 16:24:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71277, 'Database Backup [database_backup_2024-08-31-00-03-01-v3-1-6.zip]', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71329, 'New Expense Category Added [ID: 6]', '2024-08-31 01:26:28', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71333, 'New Expense Added [11]', '2024-08-31 01:32:22', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71337, 'Expense Updated [11]', '2024-08-31 01:39:44', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71344, 'New Expense Added [12]', '2024-08-31 01:51:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71345, 'New Expense Added [13]', '2024-08-31 01:53:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71382, 'New Expense Category Added [ID: 7]', '2024-08-31 03:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71383, 'New Expense Added [14]', '2024-08-31 03:02:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71804, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.172]', '2024-08-31 15:11:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71805, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.172]', '2024-08-31 15:11:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72007, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-31 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72116, 'Database Backup [database_backup_2024-09-01-00-03-01-v3-1-6.zip]', '2024-09-01 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72138, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.62]', '2024-09-01 00:44:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72922, 'Database Backup [database_backup_2024-09-02-00-04-02-v3-1-6.zip]', '2024-09-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (72999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (73435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (7343