#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=193531 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (168999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169571, 'Database Backup [database_backup_2025-01-01-00-00-03-v3-1-6.zip]', '2025-01-01 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (169999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170259, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-01 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170260, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-01 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170369, 'Database Backup [database_backup_2025-01-02-00-02-02-v3-1-6.zip]', '2025-01-02 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170823, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.37]', '2025-01-02 13:45:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170827, 'New Payment Mode Added [ID: 5, Name:Cheque]', '2025-01-02 13:50:46', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170828, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:52:57', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170832, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:54:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170833, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:56:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170834, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:56:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170838, 'Payment Recorded [ID:123, Invoice Number: INV-133/05/2024, Total: $10,000.00]', '2025-01-02 14:00:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171166, 'Database Backup [database_backup_2025-01-03-00-02-02-v3-1-6.zip]', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171524, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.69]', '2025-01-03 11:06:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171954, 'Database Backup [database_backup_2025-01-04-00-03-02-v3-1-6.zip]', '2025-01-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172642, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-04 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172643, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172743, 'Database Backup [database_backup_2025-01-05-00-04-02-v3-1-6.zip]', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:57:01', '[CRON]');
INSERT IN